﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using System.Windows.Forms;

using Thomas_Erdoesi.Forms;
using Thomas_Erdoesi.Game_Analyzer;
using Thomas_Erdoesi.Game_Player;

namespace Thomas_Erdoesi.Game_Interface
{
    class CommunicationHandler
    {
	    private Socket socket;
	    private IPAddress server_ip;

        public Label ConnectionLabel;
        public Label FramesLostLabel;
        public Label KeysLostLabel;
        public Label ScoreLabel;

        /// <summary>
        /// Communication Handler initialisieren
        /// </summary>
        /// <param name="server"></param>
        public CommunicationHandler(IPAddress server)
        {
            socket = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);

            socket.ReceiveBufferSize = 2048;
            socket.Blocking = false;
            socket.Bind(new IPEndPoint(IPAddress.Any, 0));

            server_ip = server;

            byte[] CtMame = new KeysPacket().ToByteArray();
            byte[] CtName = new CtNamePacket("Asteroidenschreck").ToByteArray();

            socket.SendTo(CtMame, CtMame.Length, SocketFlags.None, new IPEndPoint(server_ip, 1979));
            socket.SendTo(CtName, CtName.Length, SocketFlags.None, new IPEndPoint(server_ip, 1979));
        }


        /// <summary>
        /// Asteroids spielen...
        /// </summary>
        public void Run()
        {
            Run(new GameStatus());
        }

        /// <summary>
        /// Asteroid spielen
        /// </summary>
        /// <param name="Status">Statusobjekt</param>
        public void Run(GameStatus Status)
        {
            FrameAnalyzer Analyzer = new FrameAnalyzer();
            Player Player = new Player();

	        byte PrevFrame = 0;
            byte ExpectedFrame;

            Status.Server = server_ip;

            int FramesLostResetCounter = 1;
            int KeysLostResetCounter = 1;

            if (ConnectionLabel != null) ConnectionLabel.Text = server_ip.ToString();

            try
            {
                for (Status.FrameCounter = 0; ; Status.PrevFrameCounter = Status.FrameCounter++)
                {

                    // Steuerungsdaten senden und nächsten Frame empfangen
                    SendKeysPacket(Status);

                    Application.DoEvents();

                    ReceiveFramePacket(Status);

                    unchecked
                    {
                        ExpectedFrame = PrevFrame;
                        ExpectedFrame++;
                    }

                    // Warnung bei verlorenen Steuerungspaketen ausgeben
                    int KeysLost = 0;
                    int KeysLostDisplay = 0;

                    if (Status.Frame.ping != Status.Keys.ping)
                    {
                        if (Status.Keys.ping < Status.Frame.ping)
                            KeysLost = 255 + Status.Keys.ping - Status.Frame.ping;
                        else
                            KeysLost = Status.Keys.ping - Status.Frame.ping;

                        if (KeysLostLabel != null && KeysLost > KeysLostDisplay)
                        {
                            KeysLostDisplay = KeysLost;
                            KeysLostLabel.Text = KeysLostDisplay.ToString();
                            KeysLostLabel.ForeColor = Color.Red;
                            KeysLostResetCounter = 50;
                        }
                    }

                    if (KeysLostResetCounter > 0)
                        if (--KeysLostResetCounter == 0)
                            if (KeysLostLabel != null)
                            {
                                KeysLostLabel.Text = "0";
                                KeysLostLabel.ForeColor = Color.Black;
                                KeysLostDisplay = 0;
                            }

                    // Warnung bei verlorenen Frames ausgeben
                    int FramesLost = 0;
                    int FramesLostDisplay = 0;

                    if (Status.Frame.frameno != ExpectedFrame)
                    {

                        if (Status.Frame.frameno < ExpectedFrame)
                            FramesLost = 255 + Status.Frame.frameno - ExpectedFrame;
                        else
                            FramesLost = Status.Frame.frameno - ExpectedFrame;

                        Status.FrameCounter += FramesLost;

                        if (FramesLostLabel != null && FramesLost > FramesLostDisplay)
                        {
                            FramesLostDisplay = FramesLost;
                            FramesLostLabel.Text = FramesLostDisplay.ToString();
                            FramesLostLabel.ForeColor = Color.Red;
                            FramesLostResetCounter = 50;
                        }
                    }

                    if (FramesLostResetCounter > 0)
                        if (--FramesLostResetCounter == 0)
                            if (FramesLostLabel != null)
                            {
                                FramesLostLabel.Text = FramesLost.ToString();
                                FramesLostLabel.ForeColor = Color.Black;
                                FramesLostDisplay = 0;
                            }

                    PrevFrame = Status.Frame.frameno;

                    // Frame analysieren
                    Analyzer.Analyze(Status);

                    if (ScoreLabel != null) ScoreLabel.Text = Status.Score.TrimStart();

                    // Spielaktionen festlegen
                    Player.PlayGame(Status);
                }
            }
            catch (TimeExceededException)
            {
            }
            catch (GameOverException)
            {
            }
            catch (Exception)
            {
                throw;
            }
            finally
            {
                if (ConnectionLabel != null) ConnectionLabel.Text = "-";

                if (KeysLostLabel != null)
                {
                    KeysLostLabel.Text = "-";
                    KeysLostLabel.ForeColor = Color.Black;
                }

                if (FramesLostLabel != null)
                {
                    FramesLostLabel.Text = "-";
                    FramesLostLabel.ForeColor = Color.Black;
                }
            }
        }

        /// <summary>
        /// Frame per UDP empfangen
        /// </summary>
        /// <param name="Status"></param>
        private void ReceiveFramePacket(GameStatus Status)
        {
            if (socket.Poll(1000000, SelectMode.SelectRead) == false)
                throw new Exception("Während der letzten Sekunde wurde kein UDP-Paket empfangen.");

            EndPoint myRemoteEndpoint = new IPEndPoint(server_ip, 1979);

            byte[] receiveBytes = new byte[socket.Available];

            socket.ReceiveFrom(receiveBytes, ref myRemoteEndpoint);

            Status.Frame = FramePacket.FromByteArray(receiveBytes);
        }
      
        /// <summary>
        /// Steuerungsinformationen per UDP senden
        /// </summary>
        /// <param name="Status"></param>
        private void SendKeysPacket(GameStatus Status)
        {
            unchecked { Status.Keys.ping++; }

            byte[] bytCommand = Status.Keys.ToByteArray();

            socket.SendTo(bytCommand, bytCommand.Length, SocketFlags.None, new IPEndPoint(server_ip, 1979));
        }
    }
}
